#!/bin/csh
#
#-- Script to make a map of lateral variations
#-- in topography of 410 and 650-km discontinuity 
#-- through our 3-D models S362ANI+M or S362WMANI+M
#--
#-- SYNTAX:
#-- topo.e mod
#--
#-- OPTIONAL ARGUMENTS:
#-- mod: 0 for using the preferred model S362ANI+M, 1 for S362WMANI+M, default is 0 
#-- 
#-- OUTPUT:
#-- output file will be called "topo.$(model).ps"
#--
#-- EXAMPLE: topo.e 0 
#--
#-- AUTHOR: Raj Moulik, LDEO, 2014
#--
#------------------------------------------------
#-- Check for number of arguments
if ( $#argv == 1 ) then	
  set mod = $1	
else  #-- default
  echo "Usage: topo.e MOD"
  set mod = 0
  echo "Warning: Using default values, MOD = "$mod
endif
	
#------------------------------------------------
#-- Models:
if ($mod == 0) then
  set model = S362ANI+M
  set ref = "Moulik and Ekstrom (2014)"
else if ($mod == 1) then
  set model = S362WMANI+M
  set ref = "Moulik and Ekstrom (2014)"
endif
#------------------------------------------------
#-- Evaluate the topography :
./bin/topo.exe << !
$model
y
2.0
!

#
#-- Plot the topography
echo $model >! details.txt
echo $ref >> details.txt
./plottopo.scr details.txt
