#!/bin/csh
#
#-- Script to make a map of lateral anisotropic 
#-- velocity variations at a single depth through 
#-- our 3-D models S362ANI+M or S362WMANI+M
#--
#-- SYNTAX:
#-- velani_global.e depth mod
#--
#-- OPTIONAL ARGUMENTS:
#-- depth: is depth in mantle. default is 150 km, if unspecified
#-- mod: 0 for using the preferred model S362ANI+M, 1 for S362WMANI+M, default is 0 
#-- 
#-- OUTPUT:
#-- output file will be called "map.$(model).${depth}km.ps"
#--
#-- EXAMPLE: velani_global.e 0 600
#--
#-- AUTHOR: Raj Moulik, LDEO, 2014
#--
#------------------------------------------------
#-- Check for number of arguments
if ( $#argv == 2 ) then
  set depth = $1	
  set mod = $2
else if ( $#argv == 1 ) then	
  set depth = $1	
  set mod = 0 
else 
  echo "Usage: velani_global.e DEPTH MOD"
  set mod = 0
  set depth = 150
  echo "Warning: Using default values"
endif	
#------------------------------------------------
#-- Models:
if ($mod == 0) then
  set model = S362ANI+M
  set ref = "Moulik and Ekstrom (2014)"
else if ($mod == 1) then
  set model = S362WMANI+M
  set ref = "Moulik and Ekstrom (2014)"
endif
echo "DEPTH = "$depth" km, MODEL = "$model
#------------------------------------------------
#-- Evaluate the model at a depth:

./bin/velani.exe << !
$model
1
REF
2.0
-90.0 90.0 -180.0 180.0
n
$depth
!

#
#-- Plot the model
echo $model >! details.txt
echo $depth >> details.txt
echo $ref >> details.txt
./plotglobal.scr details.txt

